{% extends localPath(0) ~ "site.body.tpl" %}
{% block content %}
{% if (flags.link_news) %}
<b>   : <a href="{{ news.url }}">{{ news.title }}</a></b>
<br/><br/>
{%endif %}
{{ description }}
<br/><br/>
{% if (flags.jcheck) %}
<script language="JavaScript">
var FBF_INIT = {{ FBF_DATA }};
function FBF_CHECK() {
 var frm = document.getElementById('feedback_form');
 if (frm == null) return true;

 var i;
 for (i in FBF_INIT) {
 	if (FBF_INIT[i][1]) {
 	 if (FBF_INIT[i][0] == 'date') {
		if ((frm[i+':day'].value == '1') && (frm[i+':month'].value == '1') && (frm[i+':year'].value == '1970')) {
 			alert('{l_feedback:form.err.notfilled} ('+FBF_INIT[i][2]+')!');
 			frm[i+':day'].focus();
 			return false;
		}
 	 } else if (frm[i].value == '') {
 		alert('{l_feedback:form.err.notfilled} ('+FBF_INIT[i][2]+')!');
 		frm[i].focus();
 		return false;
 	}
   }
 }
 return true;
}
</script>
{% endif %}
<form method="post" action="{{ form_url }}" id="feedback_form" name="feedback_form">
{{ hidden_fields }}
<input type="hidden" name="id" value="{{ id }}"/>
	<table class="tableform">
{% if (flags.error) %}<tr><td colspan="2" style="background: red; color: white;"><center><b>{{ errorText }}</b></center></td></tr>{% endif %}
{% for entry in entries %}
{% if entry.type == 'text' %}
		<tr>
			<td class="label">
				{{ entry.title }}:
			</td>
			<td><input type="text" maxlength="35" name="{{ entry.name }}" class="f_input" /></td>
		</tr>
{% endif %}
{% if entry.type == 'textarea' %}
		<tr>
			<td class="label">
				{{ entry.title }}:
			</td>
			<td><textarea name="{{ entry.name }}" style="width: 300px; height: 160px" class="f_textarea" />{{ entry.value }}</textarea></td>
		</tr>
{% endif %}
{% if entry.type == 'select' %}
		<tr>
			<td class="label">
				{{ entry.title }}:
			</td>
			<td><select name="{{ entry.name }}">{{ entry.options.select }}</select></td>
		</tr>
{% endif %}
{% if entry.type == 'date' %}
		<tr>
			<td class="label">
				{{ entry.title }}:
			</td>
			<td><select name="{{ entry.name }}:day">{{ entry.options.day }}</select>.<select name="{{ entry.name }}:month">{{ entry.options.month }}</select>.<select name="{{ entry.name }}:year">{{ entry.options.year }}</select></td>
		</tr>
{% endif %}
{% endfor %}
{% if (flags.captcha) %}
<!-- Captcha check -->
		<tr>
			<td class="label">
				{{ lang['feedback:sform.captcha'] }}:
			</td>
			<td>
				<div><img id="img_captcha" onclick="this.src='{{ captcha_url }}&rand='+Math.random();" src="{{ captcha_url }}&rand={{ captcha_rand }}" alt="captcha" /></div>
				<div><input type="text" maxlength="45" name="vcode" style="width:80px" class="f_input" /></div>
			</td>
		</tr>
{% endif %}
{% if (flags.recipients) %}
		<tr>
			<td class="label">
				 :<span class="impot">*</span>
			</td>
			<td><input type="text" maxlength="35" name="name" class="f_input" /></td>
		</tr>

			<tr>
				<td class="name">{{ lang['feedback:sform.elist'] }}:</td>
				<td><select name="recipient">{{ recipients_list }}</select></td>
			</tr>
{% endif %}
	</table>
	<div class="fieldsubmit">
		<button {% if (flags.jcheck) %}onclick="return FBF_CHECK();" {% endif %} class="fbutton" type="submit"><span></span></button>
	</div>
</form>
{% endblock %}